<?php

namespace ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Product\Sections\Pricing;

use ModulesGarden\ProductsReseller\App\Libs\Repositories\Whmcs\Pricing;
use ModulesGarden\ProductsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Fields\PricingField;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use ModulesGarden\ProductsReseller\Core\UI\Widget\Forms\Sections\HiddenPricingSection;


/**
 * Description of PricingFields
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class PricingRow extends HiddenPricingSection
{
    use LoadDataToForm;

    /**
     * @var Currency
     */
    protected $currency;

    public function initContent()
    {
        foreach (Pricing::PRODUCT_TYPES as $type) {
            if($type == Pricing::TYPE_PRODUCT_RENEW && $this->getFieldName()=="onetime"){
                continue;
            }
            $disabledValue = ($type === Pricing::TYPE_PRODUCT_REGISTER) ? -1 : 0;
            $field = new PricingField();


            $field->initIds("{$this->getCurrencyCode()}[{$type}][{$this->getFieldName()}]")
                ->setPrefix($this->getCurrency()->prefix)
                ->setDecimal()
                ->setPricingMinimalValues(0, $disabledValue)
                ->setTitle($type);
            $this->addField($field);
        }
    }

    /**
     *
     * @return mixed
     */
    protected function getCurrencyCode()
    {
        $parts = explode("_", $this->getId());

        return $parts[1];
    }

    /**
     * @return mixed
     */
    protected function getFieldName()
    {
        $parts = explode("_", $this->getId());

        return $parts[0];
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }
}
