<?php

namespace ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\ConfigurableOptions\Sections\Pricing;

use ModulesGarden\ProductsReseller\App\Libs\Repositories\Whmcs\Pricing;
use ModulesGarden\ProductsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Fields\PricingField;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use ModulesGarden\ProductsReseller\Core\UI\Widget\Forms\Sections\HiddenPricingSection;

/**
 * Description of PricingFields
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class ConfigOptionRow extends HiddenPricingSection
{
    use LoadDataToForm;

    /**
     * @var Currency
     */
    protected $currency;
    protected $prefix;

    public function initContent()
    {
        foreach (Pricing::PRODUCT_FIELDS as $type)
        {
            $field = new PricingField();
            $id    = explode('----', $this->id);
            $name = $id[0] . '__' . $id[1];
            unset($id[0]);
            unset($id[1]);
            foreach ($id as $idPart)
            {
                $name .= '[' . $idPart . ']';
            }
            $field->initIds("{$name}[{$type}]")
                ->setPrefix($this->prefix)
                ->setDecimal()
                ->setPricingMinimalValues(0, 0)
                ->setTitle($type);
            $this->addField($field);
        }
    }

    /**
     *
     * @return mixed
     */
    protected function getCurrencyCode()
    {
        $parts = explode("_", $this->getId());

        return $parts[1];
    }

    /**
     * @return mixed
     */
    protected function getFieldName()
    {
        $parts = explode("_", $this->getId());

        return $parts[0];
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }

    public function setPrefix($prefix)
    {
        $this->prefix = $prefix;
    }
}
