<?php

namespace ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\ConfigurableOptions\Sections\Pricing;

use ModulesGarden\ProductsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use ModulesGarden\ProductsReseller\Core\Models\Whmcs\ProductConfigOptionSub;
use ModulesGarden\ProductsReseller\Core\UI\Widget\Forms\Sections\ConfigOptionGroupSection;


class ConfigOptionGroupRow extends ConfigOptionGroupSection
{
    use LoadDataToForm;

    protected $configOptionGroupId;
    protected $configOptionId;
    /**
     * @var Currency
     */
    protected $currency;

    public function __construct($baseId = null, $configOptionGroupId = null, $configOptionId = null, $currency = null)
    {
        $this->configOptionGroupId = $configOptionGroupId;
        $this->configOptionId      = $configOptionId;
        $this->currency            = $currency;
        parent::__construct($currency . '----' . $baseId);
    }


    public function initContent()
    {
        $configOptionSubs = ProductConfigOptionSub::where('configid', $this->configOptionId)->get();

        foreach ($configOptionSubs as $subOption)
        {
            $id      = explode('|', $subOption->optionname)[0];
            $section = new ConfigOptionRow($this->id . '----' . preg_replace( '/[\W]/', '_', $id));
            $section->setCurrency($this->currency->code);
            $section->setPrefix($this->currency->prefix);
            $section->setRawTitle(explode('|', $subOption->optionname)[1] ?: explode('|', $subOption->optionname)[0]);
            $this->addSection($section);
        }
    }

    /**
     *
     * @return mixed
     */
    protected function getCurrencyCode()
    {
        $parts = explode("_", $this->getId());

        return $parts[1];
    }

    /**
     * @return mixed
     */
    protected function getFieldName()
    {
        $parts = explode("_", $this->getId());

        return $parts[0];
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }
}
