<?php

use ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\Configuration;
use ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\HostingCustomField;
use ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\Models\ProductSettings\Repository;
use ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Calls;

use WHMCS\View\Menu\Item as MenuItem;
use function ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\Helper\sl;

$hookManager->register(
    function (MenuItem $primarySidebar) {
        $request = \ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\Helper\sl('request');
        $isProperModule = \ModulesGarden\ProductsReseller\Server\ProductsResellerServer\App\Helpers\ResellerModuleChecker::isProperModule(__DIR__);
        if(!$isProperModule)
        {
            return;
        }
        if ($request->get('action') === 'productdetails' || $request->get('action') === 'cancel')
        {
            $actions = $primarySidebar->getChild('Service Details Actions');
            if (is_a($actions, '\WHMCS\View\Menu\Item'))
            {
                $actions->removeChild('Custom Module Button Details');
            }

            if ($request->get('action') === "productdetails")
            {
                $overview = $primarySidebar->getChild('Service Details Overview');
                if (!is_a($overview, '\WHMCS\View\Menu\Item'))
                {
                    return;
                }
                $panel = $overview->getChild('Information');
                if (is_a($panel, '\WHMCS\View\Menu\Item'))
                {
                    $panel = $primarySidebar->getChild('Service Details Overview');
                    if (is_a($panel, 'WHMCS\View\Menu\Item'))
                    {
                        $panel = $panel->getChild('Information');
                        if (is_a($panel, 'WHMCS\View\Menu\Item'))
                        {
                            $panel->setUri("clientarea.php?action=productdetails&id={$_REQUEST['id']}");
                            $panel->setAttributes([]);
                        }
                    }
                }
            }

            try
            {
                $panel = $actions->getChild('Custom Module Button ssoLogin');
                if ($panel)
                {
                    $panel->setLabel(sl('lang')->T('cpanelExtended', 'ssoLogin'));
                }
                if (!function_exists('ModuleBuildParams'))
                {
                    require_once ROOTDIR . "/includes/modulefunctions.php";
                }

                $params = \ModuleBuildParams($request->get('id'));

                if (!$params['customfields'][HostingCustomField::SERVICE_ID])
                {
                    return;
                }

                $postfields =
                    [
                        "id" => $params['customfields'][HostingCustomField::SERVICE_ID],
                    ];
                $call       = new  Calls\ServiceSSORequest(Configuration::create($params), $postfields);
                $result     = $call->process();

                if ($panel)
                {
                    $panel->setUri($result['data']['redirectTo']);
                    global $CONFIG;
                    if ($CONFIG['Template'] == 'lagom' || $CONFIG['Template'] == 'lagom2')
                    {
                        $panel->setIcon('fas fa-sign-in-alt');
                    }
                    $ssoPermission = \checkContactPermission("productsso", true);
                    $ssoPermission ? $panel->setAttributes(['target' => '_blank']) : $panel->setAttributes(['disabled' => true]);
                }
            }
            catch (\Exception $e)
            {
                $overview = $primarySidebar->getChild('Service Details Actions');
                $panel    = $overview->getChild('Custom Module Button SsoLogin');
                if ($panel)
                {
                    $overview->removeChild('Custom Module Button SsoLogin');
                }
            }

        }
    }, 943
);
