{**********************************************************************
* ModuleFramework product developed. (2017-10-06)
* *
*
*  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
*  CONTACT                        ->       contact@modulesgarden.com
*
*
* This software is furnished under a license and may be used and copied
* only  in  accordance  with  the  terms  of such  license and with the
* inclusion of the above copyright notice.  This software  or any other
* copies thereof may not be provided or otherwise made available to any
* other person.  No title to and  ownership of the  software is  hereby
* transferred.
*
*
**********************************************************************}

{**
* @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
*}


{* Endpoint *}
<div class="lu-col-lg-12">
    <div class="lu-widget">
        <div class="lu-widget__header">
            <div class="lu-widget__top lu-top">
                <div class="lu-top__title">
                    {$MGLANG->absoluteTranslate("api", "documentation", "endpoint")}
                </div>
            </div>
        </div>
        <div class="lu-widget__body">
            <div class="lu-widget__content">
                {$rawObject->getCustomTplVarsValue('endpoint')}
            </div>
        </div>
    </div>
</div>


{* Access Details *}
<div class="lu-col-lg-12">
    <div class="lu-widget">
        <div class="lu-widget__header">
            <div class="lu-widget__top lu-top">
                <div class="lu-top__title">
                    {$MGLANG->absoluteTranslate("api", "documentation", "access", "title")}
                </div>
            </div>
        </div>
        <div class="lu-widget__body">
            <div class="lu-widget__content">
                <ul class="lu-list lu-list--info">
                    <li class="lu-list__item">
                        <span class="lu-list__item-title ">Username</span>
                        <span class="lu-list__value customDetailsValue">
                            {$MGLANG->absoluteTranslate("api", "documentation", "access", "params", "username")}
                        </span>
                    </li>
                    <li class="lu-list__item">
                        <span class="lu-list__item-title">Token</span>
                        <span class="lu-list__value customDetailsValue">
                            <p class="lu-text-wrap">{$MGLANG->absoluteTranslate("api", "documentation", "access", "params", "token")}</p>
                            <code>base64_encode(hash_hmac("sha256", "&lt;api-key&gt;", "&lt;email&gt;:&lt;gmdate("y-m-d H")&gt;)"))</code>
                        </span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

{* Examples *}
<div class="lu-col-lg-12">
    <div class="lu-widget">
        <div class="lu-widget__header">
            <div class="lu-widget__top lu-top">
                <div class="lu-top__title">
                    {$MGLANG->absoluteTranslate("api", "documentation", "examples")}
                </div>
            </div>
        </div>
        <div class="lu-widget__body">
            <div class="lu-widget__content">
                {literal}
                <pre>$endpoint   = "{/literal}{$rawObject->getCustomTplVarsValue('endpoint')}{literal}";
$action     = "/order/products/1";
$params     = [
    "cycle"          => "monthly",
    "hostname"       => "example.com",
    "username"       => "testuser",
    "password"       => "testpassword",
    "nsprefix"       => [ "ns1", "ns2"],
    "fields"         => ["ciuser" => "cloudinituser"],
    "configurations" => [
                        "configOptionName1" => "configOptionValue1",
                        "configOptionName2" => "configOptionValue2"
                    ],

];
$headers = [
    "username: email@example.com",
    "token: ". base64_encode(hash_hmac("sha256", "1234567890QWERTYUIOPASDFGHJKLZXCVBNM", "email@example.com:".gmdate("y-m-d H")))
];

$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, "{$endpoint}{$action}");
curl_setopt($curl, CURLOPT_POST, true);
curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($params));
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($curl);
curl_close($curl);
</pre>{/literal}
            </div>
        </div>
    </div>
</div>
