<?php

namespace ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Product\Sections\Pricing;

use ModulesGarden\ProductsReseller\App\Libs\Repositories\Whmcs\Pricing;
use ModulesGarden\ProductsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use ModulesGarden\ProductsReseller\Core\UI\Widget\Forms\Sections\TabSection;

/**
 * Description of CurrencyTab
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class CurrencyTab extends TabSection
{
    use LoadDataToForm;

    /**
     * @var Currency
     */
    private $currency;

    public function initContent()
    {
        $this->setRawTitle($this->getTitle());
        $this->generatePricing();
    }

    /**
     * Generate Pricing Tabs
     */
    public function generatePricing()
    {
        foreach (Pricing::PRODUCT_FIELDS as $field) {
            $section = new PricingRow($field);
            $section->setId("{$field}_{$this->getId()}")
                ->setCurrency($this->getCurrency())
                ->setMainContainer($this->mainContainer);

            $this->addSection($section);
        }
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }


}
