<?php

namespace ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\ConfigurableOptions\Sections\Pricing;

use ModulesGarden\ProductsReseller\App\Libs\Resources\Whmcs\Currencies\Currency;
use ModulesGarden\ProductsReseller\App\UI\Admin\Groups\Forms\Traits\LoadDataToForm;
use ModulesGarden\ProductsReseller\Core\Models\Whmcs\ProductConfigOption;
use ModulesGarden\ProductsReseller\Core\UI\Widget\Forms\Sections\TabSection;

class CurrencyTab extends TabSection
{
    use LoadDataToForm;

    protected $configOptionsGroupId;
    /**
     * @var Currency
     */
    private $currency;

    public function __construct($baseId = null, $configOptionsGroupId)
    {
        $this->configOptionsGroupId = $configOptionsGroupId;
        parent::__construct($baseId);
    }

    public function initContent()
    {
        $this->setRawTitle($this->getTitle());
        $this->generatePricing();
    }

    /**
     * Generate Pricing Tabs
     */
    public function generatePricing()
    {
        $configOptions = ProductConfigOption::where('gid', $this->configOptionsGroupId)->get();

        foreach ($configOptions as $option)
        {
            $section = new ConfigOptionGroupRow(str_replace(' ', '_', preg_replace( '/[\W]/', '_', explode('|', $option->optionname)[0])), $this->configOptionsGroupId, $option->id, $this->id);
            $section
                ->setTitle($option->optionname)
                ->setCurrency($this->getCurrency())
                ->setMainContainer($this->mainContainer);
            $this->addSection($section);
        }
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }

    protected function getConfigOptions()
    {
        return ProductConfigOption::where('gid', $this->configOptionsGroupId)->all();
    }
}
