<?php

namespace ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\Models\Whmcs;

use \Illuminate\Database\Eloquent\Model as EloquentModel;

/**
 * Description of Product
 *
 * @author Paweł Złamaniec <pawel.zl@modulesgarden.com>
 */
class ProductConfigOption extends EloquentModel
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'tblproductconfigoptions';

    protected $primaryKey = 'id';

    /**
     * Eloquent guarded parameters
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * Eloquent fillable parameters
     * @var array
     */
    protected $fillable = ['gid', 'optionname', 'optiontype', 'qtyminimum', 'qtymaximum', 'order', 'hidden'];

    /**
     * Indicates if the model should soft delete.
     *
     * @var bool
     */
    protected $softDelete = false;

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    public function suboptions()
    {
        return $this->hasMany("ModulesGarden\ProductsReseller\Server\ProductsResellerServer\Core\Models\Whmcs\ProductConfigOptionSub", "configid");
    }
}
